--DROP TABLE EST_NF_NFE_INU_ERROS_VALIDACAO
IF NOT EXISTS
(
    SELECT *
    FROM INFORMATION_SCHEMA.TABLES
    WHERE TABLE_TYPE = 'BASE TABLE'
          AND TABLE_NAME = 'EST_NF_NFE_INU_ERROS_VALIDACAO'
)
    BEGIN
        CREATE TABLE [DBO].[EST_NF_NFE_INU_ERROS_VALIDACAO]
        ([CD_CTR_ERROS]    [INT] IDENTITY(1, 1) NOT NULL, 
         [CD_INU]          [INT] NOT NULL, 
         [DT_CAD]          [DATETIME] NOT NULL, 
         [ERROS_VALIDACAO] [XML] NOT NULL, 
         [STS_ERRO]        [INT] NOT NULL, 
         [CD_USU]          [INT] NOT NULL, 
         [DT_CAD_CORRECAO] [DATETIME] NULL, 
         [VERSAO_APLIC]    [VARCHAR](150) NOT NULL, 
         CONSTRAINT [PK_EST_NF_NFE_INU_ERROS_VALIDACAO] PRIMARY KEY CLUSTERED([CD_CTR_ERROS] ASC)
         WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
        )
        ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];
END;
	GO
IF NOT EXISTS
(
    ---------------VERIFICAR SE EXISTE CONSTRAINT CRIADA -------------
    SELECT OBJ_TABLE.NAME AS TABLENAME, 
           OBJ_CONSTRAINT.NAME AS CONSTRAINTNAME
    FROM SYS.OBJECTS OBJ_TABLE
         JOIN SYS.OBJECTS OBJ_CONSTRAINT ON OBJ_TABLE.OBJECT_ID = OBJ_CONSTRAINT.PARENT_OBJECT_ID
         JOIN SYS.SYSCONSTRAINTS CONSTRAINTS ON CONSTRAINTS.CONSTID = OBJ_CONSTRAINT.OBJECT_ID
    WHERE OBJ_TABLE.NAME = 'EST_NF_NFE_INU_ERROS_VALIDACAO'
          AND OBJ_CONSTRAINT.NAME = 'DF_EST_NF_NFE_INU_ERROS_VALIDACAO_CD_INU'
)
    BEGIN   -------------------CRIAÇÃO DA CONSTRAINT--------------------------
        ALTER TABLE [DBO].[EST_NF_NFE_INU_ERROS_VALIDACAO]
        ADD CONSTRAINT [DF_EST_NF_NFE_INU_ERROS_VALIDACAO_CD_INU] DEFAULT((0)) FOR [CD_INU];
END;
	GO
IF NOT EXISTS
(
    ---------------VERIFICAR SE EXISTE CONSTRAINT CRIADA -------------
    SELECT OBJ_TABLE.NAME AS TABLENAME, 
           OBJ_CONSTRAINT.NAME AS CONSTRAINTNAME
    FROM SYS.OBJECTS OBJ_TABLE
         JOIN SYS.OBJECTS OBJ_CONSTRAINT ON OBJ_TABLE.OBJECT_ID = OBJ_CONSTRAINT.PARENT_OBJECT_ID
         JOIN SYS.SYSCONSTRAINTS CONSTRAINTS ON CONSTRAINTS.CONSTID = OBJ_CONSTRAINT.OBJECT_ID
    WHERE OBJ_TABLE.NAME = 'EST_NF_NFE_INU_ERROS_VALIDACAO'
          AND OBJ_CONSTRAINT.NAME = 'DF_EST_NF_NFE_INU_ERROS_VALIDACAO_DT_CAD'
)
    BEGIN-------------------CRIAÇÃO DA CONSTRAINT--------------------------
        ALTER TABLE [DBO].[EST_NF_NFE_INU_ERROS_VALIDACAO]
        ADD CONSTRAINT [DF_EST_NF_NFE_INU_ERROS_VALIDACAO_DT_CAD] DEFAULT(GETDATE()) FOR [DT_CAD];
END;
	GO
IF NOT EXISTS
(
    ---------------VERIFICAR SE EXISTE CONSTRAINT CRIADA -------------
    SELECT OBJ_TABLE.NAME AS TABLENAME, 
           OBJ_CONSTRAINT.NAME AS CONSTRAINTNAME
    FROM SYS.OBJECTS OBJ_TABLE
         JOIN SYS.OBJECTS OBJ_CONSTRAINT ON OBJ_TABLE.OBJECT_ID = OBJ_CONSTRAINT.PARENT_OBJECT_ID
         JOIN SYS.SYSCONSTRAINTS CONSTRAINTS ON CONSTRAINTS.CONSTID = OBJ_CONSTRAINT.OBJECT_ID
    WHERE OBJ_TABLE.NAME = 'EST_NF_NFE_INU_ERROS_VALIDACAO'
          AND OBJ_CONSTRAINT.NAME = 'DF_EST_NF_NFE_INU_ERROS_VALIDACAO_STS_ERRO'
)
    BEGIN-------------------CRIAÇÃO DA CONSTRAINT--------------------------
        ALTER TABLE [DBO].[EST_NF_NFE_INU_ERROS_VALIDACAO]
        ADD CONSTRAINT [DF_EST_NF_NFE_INU_ERROS_VALIDACAO_STS_ERRO] DEFAULT((0)) FOR [STS_ERRO];
END;
	GO
IF NOT EXISTS
(
    ---------------VERIFICAR SE EXISTE CONSTRAINT CRIADA -------------
    SELECT OBJ_TABLE.NAME AS TABLENAME, 
           OBJ_CONSTRAINT.NAME AS CONSTRAINTNAME
    FROM SYS.OBJECTS OBJ_TABLE
         JOIN SYS.OBJECTS OBJ_CONSTRAINT ON OBJ_TABLE.OBJECT_ID = OBJ_CONSTRAINT.PARENT_OBJECT_ID
         JOIN SYS.SYSCONSTRAINTS CONSTRAINTS ON CONSTRAINTS.CONSTID = OBJ_CONSTRAINT.OBJECT_ID
    WHERE OBJ_TABLE.NAME = 'EST_NF_NFE_INU_ERROS_VALIDACAO'
          AND OBJ_CONSTRAINT.NAME = 'DF_EST_NF_NFE_INU_ERROS_VALIDACAO_CD_USU'
)
    BEGIN-------------------CRIAÇÃO DA CONSTRAINT--------------------------
        ALTER TABLE [DBO].[EST_NF_NFE_INU_ERROS_VALIDACAO]
        ADD CONSTRAINT [DF_EST_NF_NFE_INU_ERROS_VALIDACAO_CD_USU] DEFAULT((0)) FOR [CD_USU];
END;	
	GO
IF NOT EXISTS
(
    ---------------VERIFICAR SE EXISTE CONSTRAINT CRIADA -------------
    SELECT OBJ_TABLE.NAME AS TABLENAME, 
           OBJ_CONSTRAINT.NAME AS CONSTRAINTNAME
    FROM SYS.OBJECTS OBJ_TABLE
         JOIN SYS.OBJECTS OBJ_CONSTRAINT ON OBJ_TABLE.OBJECT_ID = OBJ_CONSTRAINT.PARENT_OBJECT_ID
         JOIN SYS.SYSCONSTRAINTS CONSTRAINTS ON CONSTRAINTS.CONSTID = OBJ_CONSTRAINT.OBJECT_ID
    WHERE OBJ_TABLE.NAME = 'EST_NF_NFE_INU_ERROS_VALIDACAO'
          AND OBJ_CONSTRAINT.NAME = 'DF_EST_NF_NFE_INU_ERROS_VALIDACAO_VERSAO_APLIC'
)
    BEGIN-------------------CRIAÇÃO DA CONSTRAINT--------------------------
        ALTER TABLE [DBO].[EST_NF_NFE_INU_ERROS_VALIDACAO]
        ADD CONSTRAINT [DF_EST_NF_NFE_INU_ERROS_VALIDACAO_VERSAO_APLIC] DEFAULT('') FOR [VERSAO_APLIC];
END;
	GO
IF NOT EXISTS
(
    ---------------VERIFICAR SE EXISTE CONSTRAINT CRIADA -------------
    SELECT OBJ_TABLE.NAME AS TABLENAME, 
           OBJ_CONSTRAINT.NAME AS CONSTRAINTNAME
    FROM SYS.OBJECTS OBJ_TABLE
         JOIN SYS.OBJECTS OBJ_CONSTRAINT ON OBJ_TABLE.OBJECT_ID = OBJ_CONSTRAINT.PARENT_OBJECT_ID
         JOIN SYS.SYSCONSTRAINTS CONSTRAINTS ON CONSTRAINTS.CONSTID = OBJ_CONSTRAINT.OBJECT_ID
    WHERE OBJ_TABLE.NAME = 'EST_NF_NFE_INU_ERROS_VALIDACAO'
          AND OBJ_CONSTRAINT.NAME = 'FK_EST_NF_NFE_INU_ERROS_VALIDACAO_EST_NF_NFE_INU'
)
    BEGIN-------------------CRIAÇÃO DA CONSTRAINT--------------------------
        ALTER TABLE [DBO].[EST_NF_NFE_INU_ERROS_VALIDACAO]
        WITH CHECK
        ADD CONSTRAINT [FK_EST_NF_NFE_INU_ERROS_VALIDACAO_EST_NF_NFE_INU] FOREIGN KEY([CD_INU]) REFERENCES [DBO].[EST_NF_NFE_INU]([CD_INU]);
END;
	GO
IF NOT EXISTS
(
    ---------------VERIFICAR SE EXISTE CONSTRAINT CRIADA -------------
    SELECT OBJ_TABLE.NAME AS TABLENAME, 
           OBJ_CONSTRAINT.NAME AS CONSTRAINTNAME
    FROM SYS.OBJECTS OBJ_TABLE
         JOIN SYS.OBJECTS OBJ_CONSTRAINT ON OBJ_TABLE.OBJECT_ID = OBJ_CONSTRAINT.PARENT_OBJECT_ID
         JOIN SYS.SYSCONSTRAINTS CONSTRAINTS ON CONSTRAINTS.CONSTID = OBJ_CONSTRAINT.OBJECT_ID
    WHERE OBJ_TABLE.NAME = 'EST_NF_NFE_INU_ERROS_VALIDACAO'
          AND OBJ_CONSTRAINT.NAME = 'FK_EST_NF_NFE_INU_ERROS_VALIDACAO_EST_NF_NFE_INU'
)
    BEGIN-------------------CRIAÇÃO DA CONSTRAINT--------------------------
        ALTER TABLE [DBO].[EST_NF_NFE_INU_ERROS_VALIDACAO] CHECK CONSTRAINT [FK_EST_NF_NFE_INU_ERROS_VALIDACAO_EST_NF_NFE_INU];
END;
	GO